/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.BaseBlockPropertyHolder;
import com.voxelutopia.ultramarine.world.block.DiagonallyPlaceable;
import com.voxelutopia.ultramarine.world.block.state.ModBlockStateProperties;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DecorativeBlock
extends HorizontalDirectionalBlock
implements BaseBlockPropertyHolder,
DiagonallyPlaceable {
    public static final VoxelShape FULL_BLOCK = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape FULL_14 = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final VoxelShape FULL_12 = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final VoxelShape FULL_10 = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    public static final VoxelShape FULL_8 = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final VoxelShape FULL_6 = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final VoxelShape FULL_4 = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape HALF_BLOCK = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape HALF_14 = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)14.0);
    public static final VoxelShape HALF_12 = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    public static final VoxelShape HALF_6 = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0);
    public static final VoxelShape QUARTER_16 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    public static final VoxelShape QUARTER_12 = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0);
    public static final VoxelShape FLAT_16 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    public static final VoxelShape DOUBLE_FLAT_14 = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    public static final VoxelShape VASE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);
    public static final DirectionProperty HORIZONTAL_FACING_SHIFT = ModBlockStateProperties.HORIZONTAL_FACING_SHIFT;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    private final BaseBlockProperty property;
    private final ShapeFunction shape;
    private final boolean diagonallyPlaceable;
    private final boolean directional;
    private final boolean noCollision;
    private final boolean luminous;
    private final boolean noFenceConnect;
    @Nullable
    private final Direction offsetDirection;
    protected StateDefinition<Block, BlockState> stateDefinition;

    public DecorativeBlock(BaseBlockProperty property, ShapeFunction shape, boolean directional, boolean diagonallyPlaceable, boolean luminous, boolean noCollision, boolean noFenceConnect, @Nullable Direction offset) {
        super(property.properties);
        this.property = property;
        this.shape = shape;
        this.directional = directional;
        this.diagonallyPlaceable = diagonallyPlaceable;
        this.luminous = luminous;
        this.noCollision = noCollision;
        this.noFenceConnect = noFenceConnect;
        this.offsetDirection = offset;
        StateDefinition.Builder stateDefinationBuilder = new StateDefinition.Builder((Object)this);
        this.m_7926_((StateDefinition.Builder<Block, BlockState>)stateDefinationBuilder);
        this.stateDefinition = stateDefinationBuilder.m_61101_(Block::m_49966_, BlockState::new);
        BlockState state = (BlockState)this.m_49965_().m_61090_();
        if (this.isDiagonallyPlaceable()) {
            state = (BlockState)state.m_61124_((Property)DIAGONAL, (Comparable)Boolean.valueOf(false));
        }
        if (this.isDirectional()) {
            state = (BlockState)state.m_61124_((Property)f_54117_, (Comparable)Direction.NORTH);
        }
        if (this.isDiagonallyPlaceable() && this.isDirectional()) {
            state = (BlockState)state.m_61124_((Property)HORIZONTAL_FACING_SHIFT, (Comparable)Direction.NORTH);
        }
        if (this.isLuminous()) {
            state = (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true));
        }
        this.m_49959_(state);
    }

    public DecorativeBlock(Builder builder) {
        this(builder.property, builder.shape, builder.directional, builder.diagonallyPlaceable, builder.luminous, builder.noCollision, builder.noFenceConnect, builder.offset);
    }

    public static Builder with(BaseBlockProperty property) {
        return new Builder(property);
    }

    public StateDefinition<Block, BlockState> m_49965_() {
        return this.stateDefinition;
    }

    @NotNull
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState state = this.setDiagonalStateForPlacement(this.m_49966_(), pContext);
        if (this.isDirectional() && this.isDiagonallyPlaceable()) {
            Pair directions = this.getMainAndShiftedDirections(pContext);
            state = (BlockState)((BlockState)((BlockState)state.m_61124_((Property)f_54117_, (Comparable)((Direction)directions.getLeft()))).m_61124_((Property)HORIZONTAL_FACING_SHIFT, (Comparable)((Direction)directions.getRight()))).m_61124_((Property)DIAGONAL, (Comparable)Boolean.valueOf(this.getDiagonalState(pContext)));
        } else if (this.isDirectional() && !this.isDiagonallyPlaceable()) {
            state = (BlockState)state.m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_().m_122424_());
        } else if (!this.isDirectional() && this.isDiagonallyPlaceable()) {
            state = (BlockState)state.m_61124_((Property)DIAGONAL, (Comparable)Boolean.valueOf(this.getDiagonalState(pContext)));
        }
        if (this.isLuminous()) {
            state = (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        if (this.isDirectional()) {
            pBuilder.m_61104_(new Property[]{f_54117_});
        }
        if (this.isDiagonallyPlaceable()) {
            pBuilder.m_61104_(new Property[]{DIAGONAL});
        }
        if (this.isDirectional() && this.isDiagonallyPlaceable()) {
            pBuilder.m_61104_(new Property[]{HORIZONTAL_FACING_SHIFT});
        }
        if (this.isLuminous()) {
            pBuilder.m_61104_(new Property[]{LIT});
        }
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shape.getShape(pState, pLevel, pPos, pContext);
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.noCollision ? Shapes.m_83040_() : this.m_5940_(pState, pLevel, pPos, pContext);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        if (this.isLuminous()) {
            return (Boolean)state.m_61143_((Property)LIT) != false ? 14 : 0;
        }
        return 0;
    }

    @Override
    public BaseBlockProperty getProperty() {
        return this.property;
    }

    @Override
    public boolean isDiagonallyPlaceable() {
        return this.diagonallyPlaceable;
    }

    public boolean isLuminous() {
        return this.luminous;
    }

    public boolean isDirectional() {
        return this.directional;
    }

    protected static ShapeFunction simpleShape(VoxelShape shape) {
        return ($1, $2, $3, $4) -> shape;
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return this.noFenceConnect ? FULL_14 : super.m_7947_(pState, pReader, pPos);
    }

    public float m_7749_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 1.0f;
    }

    @FunctionalInterface
    public static interface ShapeFunction {
        public VoxelShape getShape(BlockState var1, BlockGetter var2, BlockPos var3, CollisionContext var4);
    }

    public static class Builder
    extends AbstractBuilder<Builder> {
        private final BaseBlockProperty property;
        private ShapeFunction shape = DecorativeBlock.simpleShape(FULL_14);
        private boolean diagonallyPlaceable;
        private boolean directional;
        private boolean luminous;
        private boolean noCollision;
        private boolean noFenceConnect;
        private Direction offset = null;

        public Builder(BaseBlockProperty property) {
            this.property = property.copy();
        }

        public Builder shaped(VoxelShape shape) {
            return this.shaped(DecorativeBlock.simpleShape(shape));
        }

        public Builder shaped(ShapeFunction shape) {
            this.shape = shape;
            return this;
        }

        public Builder diagonallyPlaceable() {
            this.diagonallyPlaceable = true;
            return this;
        }

        public Builder directional() {
            this.directional = true;
            return this;
        }

        public Builder luminous() {
            this.luminous = true;
            return this;
        }

        public Builder noCollision() {
            this.noCollision = true;
            return this;
        }

        public Builder noOcclusion() {
            this.property.properties.m_60955_();
            return this;
        }

        public Builder noFenceConnect() {
            this.noFenceConnect = true;
            return this;
        }

        public Builder placeOffset(Direction direction) {
            this.offset = direction;
            return this;
        }

        public DecorativeBlock build() {
            return new DecorativeBlock(this);
        }

        @Override
        public Builder self() {
            return this;
        }
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder<T>> {
        public abstract T self();
    }
}

